--------------------------------------------------------------------
--            SymCACP Search Module 1         Golly bits
-- Symmetrical CA Control Panel   symCACPsrch
--------------------------------------------------------------------
--  P. Rendell   12/10/2018
--------------------------------------------------------------------
--------------------------------------------------------------------
local m ={}		-- class main
m.result = ''
local g = golly()
local gr = require("buildUni") 

--------------------------------------------------------------------------------
function bool2txt(b)
   if b then
      return 'true'
   end
   return 'false'
end
--------------------------------------------------------------------------------
local function strCC(s1,s2)
   local res = ''
   if  s2 then
      if s1 then
         res = s1..s2
      else
         res = '**NIL**'..s2
      end
   elseif s1 then
      res = s1..'**NIL**'
   else
      res = '**NIL*NIL**'
   end
   return res
end
--------------------------------------------------------------------
-- init Function

   function m.init(logFile)
      m.logFile = logFile
   end
--------------------------------------------------------------------
   function m.initFind(seed, maxGen)
      m.seed = seed
      m.rule = g.getrule()
      m.width = tonumber(g.getwidth())
      m.hight = tonumber(g.getheight())
      g.setbase(32)    
      m.maxCells = m.width * m.hight
      m.estimateMaxEnd = math.min(300000, 10000 + math.floor(math.exp(-2)*math.pow(m.width,6)))
      if maxGen then m.estimateMaxEnd = maxGen end
--      m.logFile:write('initFind ('..seed..strCC(',',tostring(maxGen))..strCC(',',tostring(oscLengMax))..strCC(')->(',tostring(m.estimateMaxEnd))..strCC(',',tostring(m.oscLengMax))..')\n')
   end
--==================================================================
--     Utility Routines
--------------------------------------------------------------------
   function len(item)
      if item then
         return #item
      else
         return 0
      end
   end
--------------------------------------------------------------------
   function l(item)
      if item then
         return 'l('..item..')'
      else
         return 'l()'
      end
   end
--------------------------------------------------------------------
   function b(item)
      if item then
         return 'b(true)'
      else
         return 'b(false)'
      end
   end
--==================================================================
--     Golly Routines
--------------------------------------------------------------------
--------------------------------------------------------------------
   function universeSaveV1()
      local s = {}
      s.result = 'none'
      s.restore =   function()
                       g.select({0,0,1,1})
      		       g.clear(1)
      		       g.clear(0)
      		       g.select({})
                       g.putcells(s.universe)
                       g.setgen(s.gen)
                    end
      s.setResult = function (res)
                       s.result = res
                       if res == 'killed' then
                          m.result = 'killed'
                       end
                    end
      s.getChanges =  function(o)	-- return the number of cells which have different states in uni s and uni o
                    end        
      s.gen = tonumber(g.getgen())
      s.pop = tonumber(g.getpop())
      s.pop = math.min(s.pop, m.maxCells - s.pop)
      s.universe = g.getcells({-(m.width//2), -(m.hight//2), m.width, m.hight})
      return s
   end
--------------------------------------------------------------------
   function m.oscFoundPop(uni)
      local found
      local oscPeriod = 0
      repList = {}
      for rep = 1, 1+m.oscLengMax-m.oscLengMin do
         if (m.oscPopList[1] == m.oscPopList[1+rep]) then
            found = false
            for i = 1, #repList do
               if (rep == repList[i]) then
                  found = true
                  break
               end
            end
            if not found then
               repList[#repList+1] = rep
            end
         end
      end

      local step = 0
      for k, rep in ipairs(repList) do
         oscPeriod = rep + m.oscLengMin-1
         for i = 1, 1+m.oscLengMax-m.oscLengMin-rep do
            if (m.oscPopList[i] ~= m.oscPopList[i+rep]) then
               oscPeriod = -i
               break
            end
         end
         if (oscPeriod > 0) then
            m.logFile:write("-- oscFoundPop osc found "..oscPeriod.." gen "..uni.gen.." : "..g.getgen().."\n")
            -- check end patterns are the same
            if (oscPeriod < step) then
               uni.restore()
               step = 0
            end
            g.run(oscPeriod-step)
            step= oscPeriod
            if m.isCurrentUni(uni) then
               uni.setResult('osc')
               m.oscPeriod = oscPeriod
               break
            end
         end
         event = g.getevent()
         if (event:find("^key") or event:find("^oclick"))  then
            m.logFile:write("oscFoundPop stoped by user action gen "..uni.gen.." max gen ".. m.estimateMaxEnd.."\n")
            uni.setResult("killed")
            m.keepGoing = false
            break
         end
      end
      if step > 0 then
         uni.restore()
      end
      if (m.oscPeriod <= 0) then
         m.logFile:write("-- oscFoundPop osc not found gen "..uni.gen.." : "..g.getgen().."\n")
      end
      return (m.oscPeriod > 0)
   end
--------------------------------------------------------------------
   function m.isCurrentUni(uni)   
      local newPat = g.getcells({-(m.width//2), -(m.hight//2), m.width, m.hight})
      local found = false
      if #newPat == #uni.universe then
         found = true
         for j = 1, #newPat do
            if newPat[j] ~= uni.universe[j] then
               found = false
               break
            end
         end
      end
      return found   
   end
--------------------------------------------------------------------
-- Simpler version without complex population checks which will work with oscLengMin>1

   function m.getUniverse()
      local event
      local uni = universeSaveV1()
      if m.oscPeriod > 0 then
          g.run(m.oscPeriod)
	  if m.isCurrentUni(uni) then
	     uni.setResult('osc')
	  end
         uni.restore()
      else
         local pop = g.getpop()
         if (m.oscLengMin>1) then 
            g.run(m.oscLengMin-1)
         end
         for i = 1, (1+m.oscLengMax-m.oscLengMin)*2+1 do
            g.run(1)
            event = g.getevent()
            if (event:find("^key") or event:find("^oclick"))  then
               m.logFile:write("getUniverse stoped by user action gen "..uni.gen.." max gen ".. m.estimateMaxEnd.."\n")
               uni.setResult("killed")
               m.keepGoing = false
               break
            end
            if (pop == g.getpop()) and m.isCurrentUni(uni) then
	        uni.setResult('osc')
	        m.oscPeriod = i+m.oscLengMin-1
	        break
	    end
         end
         uni.restore()
      end
--      m.logFile:write("getUniverse gen "..uni.gen.." oscLeng "..m.oscLengMin..","..m.oscLengMax.." oscPeriod "..m.oscPeriod.."\n")
      return uni
   end
--------------------------------------------------------------------
-- this version does not work with oscLengMin > 1

--------------------------------------------------------------------
--------------------------------------------------------------------
--------------------------------------------------------------------
   function m.loopForOscEnd(step1)
      -- First loop to determine if the end is reachable by looking for oscillation based on population count
      -- follow up by checking matching patterns
      local thisStep = math.floor(step1)
      local firstStep = true
      local universeBefore, universeAfter
      local event

      m.oscPeriod = -1
--      m.logFile:write("loopForOscEnd started 1 step1 "..step1.."\n")
      m.keepGoing = true
      universeBefore = m.getUniverse() 
--      m.logFile:write("loopForOscEnd started 2 step1 "..step1.."\n")
      universeAfter = universeBefore
      m.keepGoing = (universeBefore.result ~= 'osc') 
          
      while m.keepGoing do 
         g.run(thisStep)
         g.update()
         universeAfter = m.getUniverse( )
         if (universeAfter.result == 'osc') then
            if thisStep > 1 then
               thisStep = math.max(1, (thisStep+1)//2 )
               universeAfter = universeBefore
               universeAfter.restore()
               firstStep = false
            else							-- universeAfter is lowest osc universe
               universeAfter.setResult('end')
               m.keepGoing = false
            end
         else				-- no oscilation found
            if (universeAfter.gen < m.estimateMaxEnd) then
               thisStep = math.max(2,thisStep + thisStep//2)
--               m.logFile:write("loopForOscEnd forward thisStep "..thisStep.." gen "..universeBefore.gen.." max ".. m.estimateMaxEnd.."\n")
            else
               universeAfter.setResult("maxEx")
               m.keepGoing = false
               m.logFile:write("max exceeded finished gen "..universeAfter.gen.." max ".. m.estimateMaxEnd.."\n")
            end
         end
         g.show("thisStep "..thisStep.." seed "..m.seed.." max gen "..m.estimateMaxEnd.." oscPeriod "..m.oscPeriod.." maxCells "..m.maxCells)
--         m.logFile:write("thisStep "..thisStep.." seed "..m.seed.." max gen "..m.estimateMaxEnd.." oscPeriod "..m.oscPeriod.." maxCells "..m.maxCells..' kg '..bool2txt(m.keepGoing)..'\n')
         if m.keepGoing then
            event = g.getevent()
            if (event:find("^key") or event:find("^oclick")) then
               m.logFile:write("loopForOscEnd stoped by user action gen "..universeAfter.gen.." max gen ".. m.estimateMaxEnd.."\n")
               universeAfter.setResult("killed")
               m.keepGoing = false
            end
         end
         universeBefore = universeAfter
      end
      m.oscPopList = nil
      universeBefore.restore()
      return universeAfter
   end
--------------------------------------------------------------------
--------------------------------------------------------------------

function m.doFindEnd(seed, maxGen, step1, oscLenMin, oscLenMax)  -- called from SymCACP or SymCACPscript
   m.initFind(seed, maxGen)
   m.result = 'none'
   m.pop = -1
   m.oscLengMin = 1
   m.oscLengMax = 100
   if oscLenMin then m.oscLengMin = oscLenMin end
   if oscLenMax then m.oscLengMax = oscLenMax end
   if m.rule:find(':') then
      local hexRule = m.rule:sub(1,m.rule:find(':')-1)
      m.logFile:write("FindEnd starting "..hexRule.."\n")
      if m.rule:find('HEX') then
         hexRule = hexRule:gsub('HEX','H')
      else
         hexRule = gr.convBS2Hex(hexRule)
      end
      local uni = m.loopForOscEnd(step1)
      g.update()
      g.show("Finished "..uni.result.." "..hexRule.." "..seed.." "..m.width..","..m.hight.." gen "..uni.gen..' Osc '..m.oscPeriod)
      m.logFile:write("FindEnd finished "..uni.result.." "..hexRule.." "..seed.." "..m.width..","..m.hight.." gen "..uni.gen..' Osc '..m.oscPeriod..' oscLen '..m.oscLengMax.."\n")
      m.logFile:flush()
      m.pop = uni.pop
      if m.result == 'killed' then
         return 'killed'
      else
         return uni.result         
      end
   else
      g.show('** not a torus universe **')
      return 'Not Totus'
   end
end
--------------------------------------------------------------------
--------------------------------------------------------------------
-- only sample universes before end. know end and keep 
--  after step1 generations collect leng samples.
--  sample 1 - section vertically through centre 
--        run lengths of cells of same state
--        no of cells changing state
--  sample 2 - section horizontally through centre ( as sample 1)
--  sample 3 time wise run length of 5 cells, the centre cell and it's neigbours 
function m.doCollectSection(seed, step1,leng)
end

--------------------------------------------------------------------
--------------------------------------------------------------------

--   short run giving average number of state changes per generation
--   after step1 generations collect the total state changes for leng
--   generations
--------------------------------------------------------------------
function m.doCollectChange(seed, step1,leng)
   local width = tonumber(g.getwidth())
   local hight = tonumber(g.getheight())
   local uniOne, uniTwo, event
   local uniList = g.getcells({-(width//2), -(hight//2), width, hight})
   m.logFile:write('doCollectChange list size:'..#uniList..'\n')
   function storeUni(uni, x,y)
      if not uniOne[y] then uniOne[y] = {} end
      iniOne[y][x] = true
   end
   function getUni()
      local uni = {}
      local newList = {}
      if #uniList%2 == 1 then
         for i = 1, #uniList-1,3 do
            if uniList[i+2] == 1 then
               storeUni(uni, uniList[i], uniList[i+1])
               newList[#newList+1] = uniList[i]
               newList[#newList+2] = uniList[i+1]
            end
         end
      else
         newList = uniList
         for i = 1, #uniList,2 do
            storeUni(uni, uniList[i], uniList[i+1])
         end
      end
      return {newList, uni}
   end
   
   local sum = 0
   local sumSqr = 0
   for i = 1, leng do
      uniTwo = getUni()
      g.run(step1)
      event = g.getevent()
      if (event:find("^key") or event:find("^oclick"))  then
         m.logFile:write("doCollectChange stoped by user action gen "..uni.gen.." max gen ".. m.estimateMaxEnd.."\n")
         m.result("killed")
         break
      end
      uniOne = uniTwo
      uniTwo = getUni()
      local changeCnt = 0
      for i = 1, #uniOne[1],2 do
         if not uniTwo[2][uniOne[1][i]][uniOne[1][i+1]] then
            changeCnt = changeCnt +1
         end
      end
      for i = 1, #uniTwo[1],2 do
         if not uniOne[2][uniTwo[1][i]][uniTwo[1][i+1]] then
            changeCnt = changeCnt +1
         end
      end
     outFile:write(tostring(changeCnt).."\n")
     sum = sum + changeCnt
     sumSqr = sumSqr + changeCnt*changeCnt
   end
   return {sum, sumSqr}
end

--------------------------------------------------------------------
--------------------------------------------------------------------

return m

--------------------------------------------------------------------
--                      	END OF FILE
--------------------------------------------------------------------
